clear();
clc();
close all;                              %Plots schlieen

%KONFIGURATION---------------------------------------------------------------------
aWERTETABELLE(1,:)  =["Xi", -3,     -2,     -1,    0,   	1,      2,      3];
aWERTETABELLE(2,:)  =["Yi", 749.2,  726.8,  694.7, 669.1,   641.4,  623.8,  606.8];
F1                  = @(x) x;           %Ansatzfunktionen
F2                  = @(x) 1;           %Ansatzfunktionen
sKommastellenDouble = '%.8f';           %Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen
lambda(1)           ="Lambda1";
lambda(2)           ="Lambda2";

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_WERTE = size(aWERTETABELLE,2)-1;                                            %Gibt die Anzahl der Spalten zurck (Parameter 2) abzglich 1 (Der Bezeichner der Wertereihe)

%BERECHNUNG------------------------------------------------------------------------
aLGS1="";                                                                           %Initialisierung notwendig
for(i=1:1:iANZAHL_WERTE)
    aLGS1(i,1)=num2str(F1(str2double(aWERTETABELLE(1,i+1))),sKommastellenDouble);
    aLGS1(i,2)=num2str(F2(str2double(aWERTETABELLE(1,i+1))),sKommastellenDouble);
    aLGS1(i,3)="";
    aLGS1(i,4)=num2str(str2double(aWERTETABELLE(2,i+1)),sKommastellenDouble);
end
aLGS1(ceil(iANZAHL_WERTE/2),3)=lambda(1);
aLGS1((ceil(iANZAHL_WERTE/2))+1,3)=lambda(2);
aA=str2double(aLGS1(1:iANZAHL_WERTE,1:2));
aAT=aA.';                                                                           %Berechnung transponierte Matrix
aY=str2double(aLGS1(1:iANZAHL_WERTE,size(aLGS1,2)));                                %Ergebnisvektor
aATA=aAT*aA;                                                                        %Berechnung transponierte Matrix * Matrix
aATY=aAT*aY;                                                                        %Berechnung transponierte Matrix * Ergebnisvektor
aLGS="";                                                                            %Initialisierung notwendig
for(i=1:1:2)
    aLGS(i,1)=num2str(aATA(i,1),sKommastellenDouble);
    aLGS(i,2)=num2str(aATA(i,2),sKommastellenDouble);
    aLGS(i,3)=strcat(lambda(i));
    aLGS(i,4)=num2str(aATY(i),sKommastellenDouble);
end

%AUFLSUNG_NACH_GAU---------------------------------------------------------------
aAUFLOESUNG=aLGS;
IndexErgebnis=size(aAUFLOESUNG,2);

%Pivotisierung
if(str2double(aAUFLOESUNG(2,1)) > str2double(aAUFLOESUNG(1,1)))                     
   Zwischenpeicher=aAUFLOESUNG(1,:);
   aAUFLOESUNG(1,:)=aAUFLOESUNG(2,:);
   aAUFLOESUNG(2,:)=Zwischenpeicher;
end
Quotient = str2double(aAUFLOESUNG(2,1))/str2double(aAUFLOESUNG(1,1));
aAUFLOESUNG(2,1) = num2str(str2double(aAUFLOESUNG(2,1)) - Quotient*str2double(aAUFLOESUNG(1,1)),sKommastellenDouble);
aAUFLOESUNG(2,2) = num2str(str2double(aAUFLOESUNG(2,2)) - Quotient*str2double(aAUFLOESUNG(1,2)),sKommastellenDouble);
aAUFLOESUNG(2,IndexErgebnis) = num2str(str2double(aAUFLOESUNG(2,IndexErgebnis)) - Quotient*str2double(aAUFLOESUNG(1,IndexErgebnis)),sKommastellenDouble);

%Rckwrtsauflsung
aX(2,1)=aAUFLOESUNG(2,3);
aX(2,2)="=";
aX(2,3)=num2str(str2double(aAUFLOESUNG(2,IndexErgebnis))/str2double(aAUFLOESUNG(2,2)),sKommastellenDouble);
aX(1,1)=aAUFLOESUNG(1,3);
aX(1,2)="=";
aX(1,3)=num2str((str2double(aAUFLOESUNG(1,IndexErgebnis))-(str2double(aAUFLOESUNG(1,2))*str2double(aX(2,3))))/str2double(aAUFLOESUNG(1,1)),sKommastellenDouble);
disp(aX);

%FORMATIERUNG_AUSGANGSGLEICHUNG---------------------------------------------------
F(1,:)=["f(x)=","a","*x","+b"];
if(aX(1,1)==lambda(1))
    a=str2double(aX(1,3));
    b=str2double(aX(2,3));
else
    a=str2double(aX(2,3));
    b=str2double(aX(1,3));
end
F(2,:)=["f(x)=",a,"*x",b];
disp(F);

%ERGEBNISPLOT----------------------------------------------------------------------
xACHSE              = @(x) 0*x;
Inkrement=100;
X=min(str2double(aWERTETABELLE(1,2:end))):(max(str2double(aWERTETABELLE(1,2:end)))-min(str2double(aWERTETABELLE(1,2:end))))/Inkrement:max(str2double(aWERTETABELLE(1,2:end)));
Y                   = @(x) (a*x)+b;
scatter(aWERTETABELLE(1,2:end),aWERTETABELLE(2,2:end),100,'o');
hold on;                                %Warten bis zur Plotausgabe
Offset=0.1;
text(str2double(aWERTETABELLE(1,2:end))+Offset,str2double(aWERTETABELLE(2,2:end))+Offset,cellstr(strcat(aWERTETABELLE(1,2:end)," | ",aWERTETABELLE(2,2:end))));
hold on;                                %Warten bis zur Plotausgabe
plot(X,Y(X),'color','blue');
text(X(1)+Offset,Y(X(1))-1,cellstr(strcat("y=",num2str(a),"*x+",num2str(b))));
hold on;                                %Warten bis zur Plotausgabe
plot(X,xACHSE(X),'color','black');
grid on;                                %Warten bis zur Plotausgabe
grid minor;

%PROGRAMMENDE----------------------------------------------------------------------
clearvars -except aWERTETABELLE aLGS1 aA aAT aATA aATY aLGS aAUFLOESUNG aX F                         %Workspace aufrumen